/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import gnu.regexp.RE;
import gnu.regexp.RESyntax;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.PerlDebugThread;
import org.epic.debug.db.StackFrame;
import org.epic.debug.ui.PerlDebugImages;

public class ExpressionView
extends ViewPart {
    static RE mReIsWhitespace;
    private int mCommandCount;
    SashForm sashForm;
    Text expressionInput;
    Text expressionOutput;
    Action evaluateAction;
    static /* synthetic */ Class class$0;

    public ExpressionView() {
        try {
            mReIsWhitespace = new RE((Object)"^\\s*$", 0, RESyntax.RE_SYNTAX_PERL5);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.mCommandCount = 1;
    }

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        this.sashForm = new SashForm(parent, 512);
        this.expressionInput = new Text((Composite)this.sashForm, 770);
        this.expressionInput.setEditable(true);
        this.expressionOutput = new Text((Composite)this.sashForm, 770);
        this.expressionOutput.setEditable(false);
    }

    public void setFocus() {
        this.expressionInput.setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.evaluateAction);
    }

    private void makeActions() {
        this.evaluateAction = new Action(){

            public void run() {
                ExpressionView.this.evaluateExpression();
            }
        };
        this.evaluateAction.setText("Evaluate Expression");
        this.evaluateAction.setToolTipText("Evaluate Expression");
        this.evaluateAction.setImageDescriptor(PerlDebugImages.ACTION_EXPRESSION_EVALUATE);
    }

    private void evaluateExpression() {
        StackFrame stackFrame;
        IAdaptable a = DebugUITools.getDebugContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.db.StackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((stackFrame = (StackFrame)((Object)a.getAdapter((Class)clazz))) != null) {
            try {
                PerlDebugThread thread = stackFrame.getPerlThread();
                String res = thread.evaluateStatement(this.expressionInput.getText());
                boolean isMatch = false;
                if (res != null) {
                    isMatch = mReIsWhitespace.isMatch((Object)res) || mReIsWhitespace.getAllMatches((Object)res).length > 0;
                }
                res = res == null || res.length() == 0 || isMatch ? "\n<Command(" + this.mCommandCount + ") finished>\n" : String.valueOf(res) + "\n<Command(" + this.mCommandCount + ") finished>\n";
                this.setExpressionOutput(res);
                ++this.mCommandCount;
            }
            catch (Exception e) {
                PerlDebugPlugin.log(e);
            }
        } else {
            MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)"Error", (String)("Choose Context/Stack Frame for executing Statement\n" + this.expressionInput.getText()));
        }
    }

    private void setExpressionOutput(String text) {
        this.expressionOutput.setText(text);
    }
}

