/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.ArrayValue;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.HashValue;
import org.epic.debug.db.PerlValue;
import org.epic.debug.db.ScalarValue;
import org.epic.debug.db.StackFrame;
import org.epic.debug.ui.action.HighlightVarUpdatesActionDelegate;

public abstract class PerlVariable
extends DebugElement
implements IVariable {
    private final DebuggerInterface db;
    private final StackFrame frame;
    private final DumpedEntity entity;
    private PerlValue value;
    private String quotedName;
    private Boolean contentChanged;

    protected PerlVariable(DebuggerInterface db, StackFrame frame, DumpedEntity entity) throws DebugException {
        super(frame.getDebugTarget());
        this.db = db;
        this.frame = frame;
        this.entity = entity;
    }

    public DebuggerInterface getDebuggerInterface() {
        return this.db;
    }

    public DumpedEntity getDumpedEntity() {
        return this.entity;
    }

    public abstract String getExpression() throws DebugException;

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public String getName() throws DebugException {
        return this.entity.getName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.entity.getReferenceType();
    }

    public StackFrame getStackFrame() {
        return this.frame;
    }

    public IValue getValue() throws DebugException {
        if (this.value != null) {
            return this.value;
        }
        this.value = this.isHash() ? new HashValue(this.getDebugTarget(), this) : (this.isArray() ? new ArrayValue(this.getDebugTarget(), this) : new ScalarValue(this.getDebugTarget(), this));
        return this.value;
    }

    public boolean hasContentChanged() throws DebugException {
        if (!HighlightVarUpdatesActionDelegate.getPreferenceValue()) {
            return false;
        }
        if (this.contentChanged == null) {
            this.computeContentChanged();
        }
        return this.contentChanged;
    }

    public boolean hasValueChanged() throws DebugException {
        String then;
        if (!HighlightVarUpdatesActionDelegate.getPreferenceValue()) {
            return false;
        }
        if (this.getName().startsWith("FileHandle")) {
            return false;
        }
        PerlVariable prev = this.getStackFrame().getPreviousVariable(this);
        if (prev == null) {
            return true;
        }
        String now = this.getDumpedEntity().getImmediateValue();
        if (now == null) {
            now = "undef";
        }
        if ((then = prev.getDumpedEntity().getImmediateValue()) == null) {
            then = "undef";
        }
        return !now.equals(then) || Boolean.TRUE.equals(this.contentChanged);
    }

    public boolean isArray() throws DebugException {
        return "ARRAY".equals(this.getReferenceTypeName());
    }

    public boolean isHash() throws DebugException {
        return "HASH".equals(this.getReferenceTypeName());
    }

    public boolean isPackageScope() {
        return false;
    }

    public boolean isScalar() throws DebugException {
        return "SCALAR".equals(this.getReferenceTypeName());
    }

    public void setValue(String expression) throws DebugException {
        this.throwNotSupported();
    }

    public void setValue(IValue value) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 5011, "Operation not supported", null));
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        this.throwNotSupported();
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        this.throwNotSupported();
        return false;
    }

    protected String getQuotedName() throws DebugException {
        if (this.quotedName == null) {
            String name = this.getName();
            boolean clean = true;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c >= '\u0100' || c == '\'') {
                    clean = false;
                    break;
                }
                ++i;
            }
            if (clean) {
                this.quotedName = "'" + name + "'";
            } else {
                StringBuffer buf = new StringBuffer("pack('");
                int i2 = 0;
                while (i2 < name.length()) {
                    buf.append('U');
                    ++i2;
                }
                buf.append("',");
                i2 = 0;
                while (i2 < name.length()) {
                    buf.append((int)name.charAt(i2));
                    buf.append(',');
                    ++i2;
                }
                buf.append(')');
                this.quotedName = buf.toString();
            }
        }
        return this.quotedName;
    }

    private void computeContentChanged() throws DebugException {
        if (!this.getValue().hasVariables() || this.getName().equals("%!")) {
            this.contentChanged = Boolean.FALSE;
            return;
        }
        LinkedList<IVariable[]> queue = new LinkedList<IVariable[]>();
        HashSet<String> visited = new HashSet<String>();
        queue.add(this.getValue().getVariables());
        long t1 = System.currentTimeMillis();
        while (!queue.isEmpty()) {
            IVariable[] vars = (IVariable[])queue.removeFirst();
            int i = 0;
            while (i < vars.length) {
                PerlVariable var = (PerlVariable)vars[i];
                if (visited.add(var.getDumpedEntity().getAddress())) {
                    if (var.hasValueChanged()) {
                        this.contentChanged = Boolean.TRUE;
                        return;
                    }
                    if (var.getValue().hasVariables()) {
                        queue.add(var.getValue().getVariables());
                    }
                }
                if (System.currentTimeMillis() > t1 + 5000L) {
                    System.out.println("break");
                }
                ++i;
            }
        }
        this.contentChanged = Boolean.FALSE;
    }

    private void throwNotSupported() throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 5011, "Operation not supported", null));
    }
}

