/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.HelperScript;
import org.epic.debug.db.PerlVariable;
import org.epic.debug.ui.action.ShowVarAddressActionDelegate;

public abstract class PerlValue
extends DebugElement
implements IValue {
    private static final String DB_DUMP_ENTITY = HelperScript.load("dump_entity.pl");
    private final PerlVariable holder;

    protected PerlValue(IDebugTarget target, PerlVariable holder) throws DebugException {
        super(target);
        this.holder = holder;
    }

    public String getDetailValue() throws DebugException {
        DumpedEntity entity = this.holder.getDumpedEntity();
        if (entity.isCyclicReference()) {
            return "cyclic reference";
        }
        if (!entity.isDefined()) {
            return "undef";
        }
        if (entity.getValue() != null) {
            return "'" + entity.getValue() + "'";
        }
        if (this.hasVariables()) {
            return "...";
        }
        if (this.holder.isArray()) {
            return "[]";
        }
        if (this.holder.isHash()) {
            return "{}";
        }
        return "";
    }

    public PerlVariable getHolder() {
        return this.holder;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.holder.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        DumpedEntity entity = this.holder.getDumpedEntity();
        String[] refChain = entity.getReferenceChain();
        boolean suppressSelfAddress = !ShowVarAddressActionDelegate.getPreferenceValue();
        int start = suppressSelfAddress ? 1 : 0;
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < refChain.length) {
            if (i > start) {
                buf.append("->");
            }
            buf.append(refChain[i]);
            ++i;
        }
        String detail = this.getDetailValue();
        if (detail.length() > 0) {
            if (buf.length() > 0) {
                buf.append('=');
            }
            if (detail.length() > 128) {
                detail = String.valueOf(detail.substring(0, 128)) + "...";
            }
            buf.append(detail);
        }
        return buf.toString();
    }

    public abstract IVariable[] getVariables() throws DebugException;

    public abstract boolean hasVariables() throws DebugException;

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    protected String dumpEntity(String subName) throws DebugException {
        PerlVariable holder;
        block3: {
            try {
                holder = this.getHolder();
                if (holder.getStackFrame().getThread().isSuspended()) break block3;
                return "";
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while retrieving variables from the debugger process", (Throwable)e));
            }
        }
        String code = HelperScript.replace(DB_DUMP_ENTITY, "#SET_OFFSET#", "my $offset = " + holder.getStackFrame().getFrameIndex() + ";");
        code = HelperScript.replace(code, "#SET_VAREXPR#", "my $varexpr = <<'EOT';\n" + holder.getExpression() + "\nEOT");
        code = HelperScript.replace(code, "#SET_SUBREF#", "my $subref = \\&dumpvar_epic::" + subName + ";");
        return holder.getDebuggerInterface().eval(code);
    }
}

