/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.DumpedEntityReader;
import org.epic.debug.db.HashKey;
import org.epic.debug.db.PerlValue;
import org.epic.debug.db.PerlVariable;

class HashValue
extends PerlValue {
    private final IVariable[] vars = this.parseHashContent(this.dumpEntity("dump_hash_expr"));

    public HashValue(IDebugTarget target, PerlVariable holder) throws DebugException {
        super(target, holder);
    }

    public IVariable[] getVariables() throws DebugException {
        return this.vars;
    }

    public boolean hasVariables() throws DebugException {
        return this.vars.length > 0;
    }

    private IVariable[] parseHashContent(String content) throws DebugException {
        DumpedEntityReader r = new DumpedEntityReader(content);
        ArrayList<HashKey> vars = new ArrayList<HashKey>();
        try {
            while (r.hasMoreEntities()) {
                vars.add(new HashKey(this.getHolder().getDebuggerInterface(), this.getHolder(), r.nextEntity()));
            }
        }
        catch (Exception e) {
            PerlDebugPlugin.log(e);
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while dumping array content; contents of the Variables view may become invalid", (Throwable)e));
        }
        return vars.toArray(new IVariable[vars.size()]);
    }
}

