/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import org.eclipse.debug.core.DebugException;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.PerlVariable;

class HashKey
extends PerlVariable {
    private final PerlVariable hash;

    protected HashKey(DebuggerInterface db, PerlVariable hash, DumpedEntity entity) throws DebugException {
        super(db, hash.getStackFrame(), entity);
        this.hash = hash;
    }

    public String getExpression() throws DebugException {
        StringBuffer buf = new StringBuffer();
        int refCount = this.getDumpedEntity().getReferenceCount() - 1;
        int i = 0;
        while (i < refCount) {
            buf.append("${");
            ++i;
        }
        buf.append(this.hash.getExpression());
        buf.append("->{");
        buf.append(this.getQuotedName());
        buf.append("}");
        i = 0;
        while (i < refCount) {
            buf.append("}");
            ++i;
        }
        return buf.toString();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hash.getName().equals("%!") ? false : super.hasValueChanged();
    }
}

