/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.epic.debug.PerlBreakpoint;

public class PerlLineBreakpoint
extends PerlBreakpoint
implements ILineBreakpoint {
    private static final String PERL_LINE_BREAKPOINT = "org.epic.debug.perlLineBreakpointMarker";
    private static final String CONDITION_ENABLED = "org.epic.debug.conditionEnabled";
    private static final String CONDITION = "org.epic.debug.condition";
    private int hitCount = 0;
    private String regExp = "";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.PerlLineBreakpoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PerlLineBreakpoint() {
    }

    public PerlLineBreakpoint(IResource resource, int lineNumber) throws DebugException {
        this(resource, lineNumber, -1, -1, true, new HashMap(8), PERL_LINE_BREAKPOINT);
    }

    protected PerlLineBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, boolean add, Map attributes, String markerType) throws DebugException {
        if (!$assertionsDisabled && attributes == null) {
            throw new AssertionError();
        }
        this.createPerlLineBreakpoint(resource, lineNumber, charStart, charEnd, add, attributes, markerType);
    }

    public void addLineBreakpointAttributes(Map attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put("PerlDebug_INVALID_POS", new Boolean(false));
        attributes.put("org.eclipse.debug.core.persisted", Boolean.TRUE);
        attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
        attributes.put("org.eclipse.debug.core.registered", Boolean.FALSE);
    }

    public void createPerlLineBreakpoint(final IResource resource, final int lineNumber, final int charStart, final int charEnd, final boolean add, final Map attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PerlLineBreakpoint.this.setMarker(resource.createMarker(markerType));
                PerlLineBreakpoint.this.addLineBreakpointAttributes(attributes, PerlLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                PerlLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                PerlLineBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void run(IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{conditionEnabled});
        this.recreate();
    }

    public void setCondition(String condition) throws CoreException {
        this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
        this.recreate();
    }

    public String getRegExp() {
        return this.regExp;
    }

    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    private void recreate() {
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public String toString() {
        try {
            return this.getResourcePath() + ":" + this.getLineNumber();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }
}

