/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.epic.core.util.FileUtilities;
import org.epic.debug.PerlDebugPlugin;

public abstract class PerlBreakpoint
extends Breakpoint {
    public static final String INVALID_POS = "PerlDebug_INVALID_POS";

    public IEditorInput getEditorInput() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench bench = PerlDebugPlugin.getDefault().getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            FileEditorInput input = new FileEditorInput((IFile)this.getMarker().getResource());
            return input;
        }
        return FileUtilities.getFileEditorInput((IPath)this.getMarker().getResource().getLocation());
    }

    public String getModelIdentifier() {
        return PerlDebugPlugin.getUniqueIdentifier();
    }

    public IPath getResourcePath() {
        return this.getMarker().getResource().getLocation();
    }

    public boolean isInvalidBreakpointPosition() {
        return this.getMarker().getAttribute(INVALID_POS, false);
    }

    public void setInvalidBreakpointPosition(boolean value) throws CoreException {
        this.getMarker().setAttribute(INVALID_POS, value);
    }

    protected IDocument getDocument() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IDocument doc = null;
        IWorkbench bench = PerlDebugPlugin.getDefault().getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            FileEditorInput input = new FileEditorInput((IFile)this.getMarker().getResource());
            TextEditor editor = (TextEditor)page.findEditor((IEditorInput)input);
            doc = editor.getDocumentProvider().getDocument((Object)input);
        }
        if (doc == null) {
            StringBuffer sourceCode = new StringBuffer();
            int BUF_SIZE = 1024;
            char[] buf = new char[BUF_SIZE];
            File inputFile = new File(this.getMarker().getResource().getLocation().toString());
            try {
                BufferedReader in = new BufferedReader(new FileReader(inputFile));
                int read = 0;
                while ((read = in.read(buf)) > 0) {
                    sourceCode.append(buf, 0, read);
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            doc = new Document(sourceCode.toString());
        }
        return doc;
    }
}

